﻿#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://10.91.160.135:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")

# Get sites
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
$siteID = $siteList.data[0].id

###GET Remote Agents
Write-Output "Remote Agents"
Write-Output "----"
$ramAgentList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/agents" -Method 'GET' -Headers $authHeader
Write-Output $ramAgentList | ConvertTo-Json
foreach ($ramAgentList in $ramAgentList.data)
{
    Write-Output ("Remote Agent  $($ramAgentList.id): $($ramAgentList.attributes.name)")
}

#######

###GET Remote Agent Templates
Write-Output "Remote Agents"
Write-Output "----"
$ramAgentList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/agents" -Method 'GET' -Headers $authHeader
$ramAgentID = $ramAgentList.data[0].id

###GET Remote Agent Settings
Write-Output "GET Specific Remote Agent Settings: " $ramAgentID
Write-Output "----"
$ramAgent = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/agents/$ramAgentID" -Method 'GET' -Headers $authHeader
Write-Output $ramAgent | ConvertTo-Json


###############
##GET Remote Agent Template ID
Write-Output "Remote Agent Templates"
Write-Output "----"
$ramTemplateList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates" -Method 'GET' -Headers $authHeader
Write-Output $ramTemplateList | ConvertTo-Json -Depth 10
foreach ($ramTemplateList in $ramTemplateList.data)
{
    Write-Output ("Remote Agent Template  $($ramTemplateList.id): $($ramTemplateList.attributes.name)")
}


#######
###
#POST New RAM Template
Write-Output "POST RAM Template"
Write-Output "-----"
$update = 
'{
  "data": {
    "attributes": {
      "name": "NewRAMTemplateName",
      "updateInterval": "EveryFiveMinutes",
      "eventRuleIds": [
        "d352632d-5f3f-49bf-99af-849f7453dd0a"
      ],
      "autoEnroll": true,
      "autoEnrollDate": 0,
      "homeFolder": "/Usr/Agents/%AgentNetBIOSName%/",
      "updateFailure": "Stop_Disable_Unenroll",
      "enableIPAccess": true,
      "ipAccess": {
        "masks": [
          {
            "ipMask": "0.0.0.0",
            "reason": "",
            "matchAction": "Deny",
            "timeStamp": 0,
            "autobanEntry": true
          }
        ],
        "defaultAction": "Allow"
      }
    }
  }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates" -Method 'POST' -Headers $authHeader -Body $update


###############
##GET Remote Agent Templates
$ramTemplateList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates" -Method 'GET' -Headers $authHeader
$ramTemplateID = $ramTemplateList.data[0].id

####
#GET Remote Agent Template by ID
Write-Output "Remote Agent Template by ID: " $ramTemplateID
Write-Output "----"
$ramTemplate = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates/$ramTemplateID" -Method 'GET' -Headers $authHeader
Write-Output $ramTemplate | ConvertTo-Json -Depth 10


####################################
##########
##GET Remote Agent Template ID
$ramTemplateList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates" -Method 'GET' -Headers $authHeader
$ramTemplateID = $ramTemplateList.data[0].id

###
##Patch Remote Agent Template by ID
Write-Output "Remote Agent Template Patch (update)"
Write-Output "-----"
$update = 
'{
  "data": {
    "attributes": {
        "ipAccess": {
        "masks": [
          {
            "ipMask": "1.1.1.1",
            "reason": "",
            "matchAction": "Deny",
            "timeStamp": 0,
            "autobanEntry": false
          }
        ],
        "defaultAction": "Allow"
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates/$ramTemplateID" -Method 'PATCH' -Headers $authHeader -Body $update


####################################
##########
##GET Remote Agent Template ID
$ramTemplateList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates" -Method 'GET' -Headers $authHeader
$ramTemplateID = $ramTemplateList.data[1].id

####
#DELETE Remote Agent Template by ID
$ramTemplateList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ram/templates/$ramTemplateID" -Method 'DELETE' -Headers $authHeader
